#ifndef ZMODELER_STRUCT_OBJECT_H_INCLUDED
#define ZMODELER_STRUCT_OBJECT_H_INCLUDED

/********************************************************************
//    Here they are: OBJECTS. Object is a set of Vertexes, Faces,
//  name, a greate deal of modify routines
********************************************************************/

#include "../Common/ZMMath.h"
class DllExport tObject: public tAbstract
{
public:
//-------------------------
//  data members
  char          *ObjectName;       // Required
  tVertexTable  *VertTable;
  tFaceTable    *FaceTable;
  tPOINT        BoundMin, BoundMax;
  tPOINT        BoundVisualMin, BoundVisualMax;
  tMATRIX       mTransform;   // ZM v1.06

  struct
  {
    //solid rendering
    tRenderBlock*  pRenderBlocks;
    long          numRenderBlocks;
    //wire rendering with/without highlight
    tWireBlock*    pWireBlocks;
    long          numWireBlocks;
  }VisualData;

  // the set of visual update/init functions.
  z3dVisualUpdaters Visual;

//-------------------------
//  construction/deconstruction
  tObject();
  tObject(char* name);
  tObject(char* name, int verts, int faces);
  virtual ~tObject();

//-------------------------
//  functions

  //draws an object on supplied CDC object
  virtual void Draw(  CDC* pDC,
            z3dViewDescriptor* pView,
            BOOL  DrawMarked);
  //Returns TRUE if cover factor of the object (marked/not) was changed by loc point.
  //It depends on CurrentState.GetLevel().
  virtual BOOL Cover(  POINT *loc,
            z3dViewDescriptor* pView,
            BOOL Multy,
            UINT CoverRadius,
            BOOL *IsMatch);

  BOOL  AllowGenericEdit();
  BOOL  AllowLowLevelEdit();

  // creates a full copy of the object
  tObject*  GetCopy();

  // performs update/rebuid render and/or wire blocks.
  DWORD DoWhatRequire(DWORD nAdditionalRequire);

  // returns a center of the bounding box
  tPOINT GetCenterPoint();

  // returns a center point of singe face
  tPOINT GetFaceCenterPoint(long index);

  // inits max and min bounding points
  void GetMaxMinPoints(tPOINT *max, tPOINT *min);

  // updates bounding box
  void UpdateBoundary() {  GetMaxMinPoints(&BoundMax, &BoundMin);};

  // marks or selects all vertices
  void MarkUpAllVertices(BOOL MarkedMode, BOOL Selection);

  // unmarks or deselects all vertices
  void UnMarkUpAllVertices(BOOL MarkedMode, BOOL Selection);

  // flips normals if object is marked/selected. Can reoreint all faces as well
  void Reorient(BOOL MarkedMode, BOOL Selection, BOOL AndFaces);
  
  // moves marked or selected vertices to supplied offset
  void MoveOffset (tPOINT *Offset, BOOL MarkedMode, BOOL Selection);
  
  // rotates marked or selected vertices to supplied angle in supplied view
  void Rotate(z3dViewDescriptor* pView, float Angle, BOOL MarkedMode, BOOL Selection, tPOINT& axis, tPOINT& base);

  // rotates normals of marked or selected vertices to supplied angle in supplied view
  void RotateNormal(z3dViewDescriptor* pView,float Angle, BOOL MarkedMode, BOOL Selection, tPOINT& axis, tPOINT& base);

  // scales marked or selected vertices to supplied values (x,y,z)
  void Scale(float XScale, float YScale, float ZScale, BOOL MarkedMode, BOOL Selection);

  //---------------------------------------------------------------
  // if object is marked or selected, mirrors it vertices in supplied view
  // depending on CurrentState.GetEditMode()
  //---------------------------------------------------------------
  void Mirror (BOOL bX, BOOL bY, BOOL bZ, BOOL MarkedMode, BOOL Selection);

  // merges either marked or selected vertices into one vertex.
  void UniteVertices(BOOL MarkedMode, BOOL Selection);

  // resets normals to (0.0f, 0.0f, 0.0f)
  void ResetNormals(BOOL MarkedMode, BOOL Selection);

  // re-calculates normals to unit length in either marked or selected vertices.
  void CalculateNormals(BOOL MarkedMode, BOOL Selection, BOOL Extended);

  // re-calculates normals to unit length in either marked or selected vertices.
  void UpdateNormals(BOOL MarkedMode, BOOL Selection);

  // resets normals to unit length in either marked or selected vertices.
  void NormalizeNormals(BOOL MarkedMode, BOOL Selection);

  //---------------------------------------------------------------
  // Changes normals direction in either marked or selected vertices.
  // it can flip any axis (component) x,y,z or all of them at a time
  //---------------------------------------------------------------
  void FlipNormals(BOOL MarkedMode, BOOL Selection, BOOL FlipX, BOOL FlipY, BOOL FlipZ);

  void UnTransform();
  void Transform(tMATRIX& mat);
  void SetTransform(tMATRIX& mat);
  //---------------------------------------------------------------
  // takes the vertices and faces tables away form supplied object.
  // the supplied object is usually no longer used.
  //---------------------------------------------------------------
  void TakeAway(tObject* src);

  // shares vertices and faces tables with supplied object. Rarely used.
  void Share(const tObject* src);
};


//generic nothing-render stub.
DllExport DWORD CALLBACK NullRenderer3D(tObject* pObj, z3dViewDescriptor* pDesc);

#endif

